/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.testing;

import de.weltraumschaf.commons.validate.Validate;
import java.util.concurrent.Callable;

public final class DelayedRepeater {
    private final int waitMillies;
    private final int maxRetries;
    private int currentRetries;

    private DelayedRepeater(int waitMillies, int maxRetries) {
        Validate.isTrue((waitMillies > 0 ? 1 : 0) != 0, (String)"Parameter 'waitMillies' must not be less than 1!");
        Validate.isTrue((maxRetries > 0 ? 1 : 0) != 0, (String)"Parameter 'maxRetries' must not be less than 1!");
        this.waitMillies = waitMillies;
        this.maxRetries = maxRetries;
    }

    boolean shouldFail() {
        return this.currentRetries == this.maxRetries;
    }

    public void execute(Runnable retriedAssertions) throws InterruptedException {
        Validate.notNull((Object)retriedAssertions, (String)"retriedAssertions");
        this.execute(new RunnableInvoker(retriedAssertions));
    }

    public void execute(Callable<Void> retriedAssertions) throws InterruptedException {
        Validate.notNull(retriedAssertions, (String)"retriedAssertions");
        this.execute(new CallableInvoker(retriedAssertions));
    }

    private void execute(Invoker wrapped) throws InterruptedException {
        this.currentRetries = 1;
        while (true) {
            try {
                Thread.sleep(this.waitMillies);
                wrapped.execute();
            }
            catch (AssertionError ex) {
                if (this.shouldFail()) {
                    throw ex;
                }
                ++this.currentRetries;
                continue;
            }
            break;
        }
    }

    public static DelayedRepeater create(int waitMillies, int maxRetries) {
        return new DelayedRepeater(waitMillies, maxRetries);
    }

    private static final class CallableInvoker
    implements Invoker {
        private final Callable<Void> target;

        private CallableInvoker(Callable<Void> target) {
            this.target = (Callable)Validate.notNull(target, (String)"target");
        }

        @Override
        public void execute() {
            try {
                this.target.call();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    private static final class RunnableInvoker
    implements Invoker {
        private final Runnable target;

        private RunnableInvoker(Runnable target) {
            this.target = (Runnable)Validate.notNull((Object)target, (String)"target");
        }

        @Override
        public void execute() {
            this.target.run();
        }
    }

    private static interface Invoker {
        public void execute();
    }
}

