/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.testing.rules;

import de.weltraumschaf.commons.testing.rules.RunMaxTimes;
import de.weltraumschaf.commons.testing.rules.RunTimes;
import de.weltraumschaf.commons.validate.Validate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class Repeater
implements TestRule {
    public Statement apply(Statement base, Description description) {
        Validate.notNull((Object)base, (String)"base");
        Validate.notNull((Object)description, (String)"description");
        if (this.hasRunTimesAnnotation(description)) {
            int times = ((RunTimes)description.getAnnotation(RunTimes.class)).value();
            this.validateTimes(times, RunTimes.class);
            return new RepeatStatement(times, base);
        }
        if (this.hasRunMaxTimesAnnotation(description)) {
            int times = ((RunMaxTimes)description.getAnnotation(RunMaxTimes.class)).value();
            this.validateTimes(times, RunMaxTimes.class);
            return new RepeatUntilSuccessStatement(times, base);
        }
        return base;
    }

    private void validateTimes(int times, Class<? extends Annotation> annotation) {
        if (times < 1) {
            throw new IllegalArgumentException(String.format("The repeater annotation @%s needs a value greater that 0! You gave %d.", annotation.getSimpleName(), times));
        }
    }

    boolean hasRunTimesAnnotation(Description description) {
        return null != description.getAnnotation(RunTimes.class);
    }

    boolean hasRunMaxTimesAnnotation(Description description) {
        return null != description.getAnnotation(RunMaxTimes.class);
    }

    private static final class RepeatUntilSuccessStatement
    extends BaseRepeatStatement {
        private RepeatUntilSuccessStatement(int times, Statement statement) {
            super(times, statement);
        }

        public void evaluate() throws Throwable {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            boolean failed = true;
            for (int i = 0; i < this.times(); ++i) {
                try {
                    this.base().evaluate();
                    failed = false;
                    break;
                }
                catch (Throwable t) {
                    errors.add(t);
                    continue;
                }
            }
            if (failed) {
                this.assertNoErrors(errors);
            }
        }
    }

    private static final class RepeatStatement
    extends BaseRepeatStatement {
        private RepeatStatement(int times, Statement base) {
            super(times, base);
        }

        public void evaluate() throws Throwable {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            for (int i = 0; i < this.times(); ++i) {
                try {
                    this.base().evaluate();
                    continue;
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
            this.assertNoErrors(errors);
        }
    }

    static abstract class BaseRepeatStatement
    extends Statement {
        private static final double HUNDRED_PERCENT = 100.0;
        private final int times;
        private final Statement base;

        BaseRepeatStatement(int times, Statement base) {
            Validate.isTrue((times > 0 ? 1 : 0) != 0, (String)"Parameter 'times' must be greater than 0!");
            this.times = times;
            this.base = (Statement)Validate.notNull((Object)base, (String)"base");
        }

        int times() {
            return this.times;
        }

        Statement base() {
            return this.base;
        }

        void assertNoErrors(Collection<? extends Throwable> errors) {
            Validate.notNull(errors, (String)"errors");
            if (errors.isEmpty()) {
                return;
            }
            throw new AssertionError((Object)BaseRepeatStatement.formatErrors(errors, this.times));
        }

        static String formatErrors(Collection<? extends Throwable> errors, int times) {
            Validate.notNull(errors, (String)"errors");
            StringBuilder message = new StringBuilder();
            message.append(String.format(Locale.US, "There were %d (%.2f %%) errors in %d run", errors.size(), BaseRepeatStatement.calculateFailedRepetitionPercentage(times, errors.size()), times));
            if (1 < times) {
                message.append('s');
            }
            if (errors.isEmpty()) {
                return message.toString();
            }
            message.append(':');
            int i = 1;
            for (Throwable throwable : errors) {
                StringWriter stackTrace = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stackTrace));
                message.append(String.format("\n%d. %s", i, ((Object)stackTrace).toString()));
                ++i;
            }
            return message.toString();
        }

        static double calculateFailedRepetitionPercentage(int times, int errors) {
            Validate.isTrue((times > 0 ? 1 : 0) != 0, (String)"Parameter times must not be less than 1!");
            Validate.isTrue((errors >= 0 ? 1 : 0) != 0, (String)"Parameter errors must not be less than 0!");
            return (double)errors * 100.0 / (double)times;
        }
    }
}

