/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.testing;

import de.weltraumschaf.commons.application.ApplicationException;
import de.weltraumschaf.commons.system.ExitCode;
import de.weltraumschaf.commons.validate.Validate;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class ApplicationExceptionCodeMatcher<T extends ApplicationException>
extends TypeSafeMatcher<T> {
    private final ExitCode expectedExitCode;

    public ApplicationExceptionCodeMatcher(ExitCode expectedExitCode) {
        this.expectedExitCode = (ExitCode)Validate.notNull((Object)expectedExitCode, (String)"expectedExitCode");
    }

    public void describeTo(Description description) {
        description.appendText("exception with exit code ");
        description.appendText(this.expectedExitCode.toString());
    }

    protected boolean matchesSafely(T item) {
        return this.expectedExitCode.getCode() == item.getExitCode().getCode();
    }

    protected void describeMismatchSafely(T item, Description mismatch) {
        mismatch.appendText("exit code ");
        mismatch.appendText(item.getExitCode().toString());
    }

    @Factory
    public static <T extends ApplicationException> Matcher<T> hasExitCode(ExitCode expectedExitCode) {
        return new ApplicationExceptionCodeMatcher<T>(expectedExitCode);
    }
}

