/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.testing;

import de.weltraumschaf.commons.testing.CapturingPrintStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class CapturedOutput
implements TestRule {
    private final CapturedOutputMatcherBuilder outMatcherBuilder = new CapturedOutputMatcherBuilder();
    private final CapturedOutputMatcherBuilder errMatcherBuilder = new CapturedOutputMatcherBuilder();
    private final CapturingPrintStream out;
    private final CapturingPrintStream err;
    private PrintStream outBackup;
    private PrintStream errBackup;

    public CapturedOutput() throws UnsupportedEncodingException {
        this(Charset.defaultCharset().name());
    }

    public CapturedOutput(String encoding) throws UnsupportedEncodingException {
        this.out = new CapturingPrintStream(encoding);
        this.err = new CapturingPrintStream(encoding);
    }

    public void expectOut(String substring) {
        this.expectOut((Matcher<String>)CoreMatchers.containsString((String)CapturedOutput.notNull(substring, "substring")));
    }

    public void expectOut(Matcher<String> matcher) {
        this.outMatcherBuilder.add(CapturedOutput.notNull(matcher, "matcher"));
    }

    public void expectErr(String substring) {
        this.expectErr((Matcher<String>)CoreMatchers.containsString((String)CapturedOutput.notNull(substring, "substring")));
    }

    public void expectErr(Matcher<String> matcher) {
        this.errMatcherBuilder.add(CapturedOutput.notNull(matcher, "matcher"));
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                CapturedOutput.this.redirectOutputStreams();
                try {
                    base.evaluate();
                    CapturedOutput.this.assertCapturedOut();
                    CapturedOutput.this.assertCapturedErr();
                }
                finally {
                    CapturedOutput.this.restoreOutputStreams();
                }
            }
        };
    }

    private void redirectOutputStreams() {
        this.outBackup = System.out;
        System.setOut(this.out.reset());
        this.errBackup = System.err;
        System.setErr(this.err.reset());
    }

    private void assertCapturedErr() throws UnsupportedEncodingException {
        if (this.errMatcherBuilder.expectsSomething()) {
            MatcherAssert.assertThat((Object)this.err.getCapturedOutput(), this.errMatcherBuilder.build());
        }
    }

    private void assertCapturedOut() throws UnsupportedEncodingException {
        if (this.outMatcherBuilder.expectsSomething()) {
            MatcherAssert.assertThat((Object)this.out.getCapturedOutput(), this.outMatcherBuilder.build());
        }
    }

    private void restoreOutputStreams() {
        System.setOut(this.outBackup);
        System.setErr(this.errBackup);
    }

    private static <T> T notNull(T subject, String description) {
        if (null == subject) {
            throw new NullPointerException(String.format("Parameter '%s' must not be null!", description));
        }
        return subject;
    }

    private static final class CapturedOutputMatcherBuilder {
        private final List<Matcher<String>> matchers = new ArrayList<Matcher<String>>();

        private CapturedOutputMatcherBuilder() {
        }

        void add(Matcher<String> matcher) {
            this.matchers.add(matcher);
        }

        boolean expectsSomething() {
            return !this.matchers.isEmpty();
        }

        Matcher<String> build() {
            if (this.matchers.size() == 1) {
                return this.matchers.get(0);
            }
            return CoreMatchers.allOf(this.castedMatchers());
        }

        private List<Matcher<? super String>> castedMatchers() {
            return new ArrayList<Matcher<? super String>>(this.matchers);
        }
    }
}

