/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.swing;

import de.weltraumschaf.commons.system.DefaultExiter;
import de.weltraumschaf.commons.system.Exitable;
import de.weltraumschaf.commons.system.OperatingSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SwingFrame
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(SwingFrame.class.getName());
    private static final long serialVersionUID = 1L;
    protected final JPanel panel = new JPanel();
    private boolean exitOnCloseWindow;
    private transient Exitable exiter = new DefaultExiter();

    public SwingFrame(String title) {
        super(title);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panel, "Center");
    }

    public final void init() {
        this.initLookAndFeel();
        if (this.exitOnCloseWindow) {
            this.bindWindowClosing();
        }
        this.initMenu();
        this.initToolBar();
        this.initPanel();
    }

    public final void setExitOnCloseWindow(boolean exitOnCloseWindow) {
        this.exitOnCloseWindow = exitOnCloseWindow;
    }

    public final void setExiter(Exitable exiter) {
        this.exiter = exiter;
    }

    public final JPanel getPanel() {
        return this.panel;
    }

    protected void initLookAndFeel() {
        OperatingSystem os = OperatingSystem.determine((String)"os.name");
        if (os == OperatingSystem.MACOSX) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    protected void bindWindowClosing() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingFrame.this.exiter.exit(0);
            }
        });
    }

    protected void initMenu() {
    }

    protected void initToolBar() {
    }

    protected void initPanel() {
    }
}

