/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.string;

import java.util.Iterator;
import java.util.Objects;

public final class StringJoiner {
    public static final String EMPTY = "";

    private StringJoiner() {
        throw new UnsupportedOperationException("Must not be caled via reflection!");
    }

    @SafeVarargs
    public static <T> String join(T ... elements) {
        return StringJoiner.join((Object[])elements, EMPTY);
    }

    public static String join(Object[] array, char separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        for (Object element : array) {
            if (element == null) continue;
            if (!first && separator > '\u0000') {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(long[] array, char separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        long[] lArray = array;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long element = lArray[i];
            if (element == null) continue;
            if (!first && separator > '\u0000') {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(int[] array, char separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        int[] nArray = array;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer element = nArray[i];
            if (element == null) continue;
            if (!first && separator > '\u0000') {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(short[] array, char separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        short[] sArray = array;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short element = sArray[i];
            if (element == null) continue;
            if (!first && separator > '\u0000') {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(byte[] array, char separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        byte[] byArray = array;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte element = byArray[i];
            if (element == null) continue;
            if (!first && separator > '\u0000') {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(char[] array, char separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        char[] cArray = array;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character element = Character.valueOf(cArray[i]);
            if (element == null) continue;
            if (!first && separator > '\u0000') {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(float[] array, char separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        float[] fArray = array;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float element = Float.valueOf(fArray[i]);
            if (element == null) continue;
            if (!first && separator > '\u0000') {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(double[] array, char separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        double[] dArray = array;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double element = dArray[i];
            if (element == null) continue;
            if (!first && separator > '\u0000') {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(Object[] array, String separator) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        StringBuilder buffer = new StringBuilder(array.length * 16);
        boolean first = true;
        for (Object element : array) {
            if (element == null) continue;
            if (!first && separator != null) {
                buffer.append(separator);
            }
            buffer.append(element);
            first = false;
        }
        return buffer.toString();
    }

    public static String join(Iterator<?> iterator, char separator) {
        return StringJoiner.join(iterator, separator > '\u0000' ? String.valueOf(separator) : EMPTY);
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (iterator == null) {
            return EMPTY;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return EMPTY;
        }
        return StringJoiner.join(iterable.iterator(), separator);
    }

    public static String join(Iterable<?> iterable, String separator) {
        if (iterable == null) {
            return EMPTY;
        }
        return StringJoiner.join(iterable.iterator(), separator);
    }
}

