/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

import de.weltraumschaf.commons.guava.Maps;
import de.weltraumschaf.commons.shell.MainCommandType;
import de.weltraumschaf.commons.shell.SubCommandType;
import de.weltraumschaf.commons.shell.token.ShellToken;
import de.weltraumschaf.commons.validate.Validate;
import java.util.Map;

public abstract class LiteralCommandMap {
    private final Map<String, MainCommandType> mainCommands = Maps.newHashMap();
    private final Map<String, SubCommandType> subCommands = Maps.newHashMap();
    private final SubCommandType defaultSubCommand;

    public LiteralCommandMap(SubCommandType defaultSubCommand) {
        this.defaultSubCommand = (SubCommandType)Validate.notNull((Object)defaultSubCommand, (String)"defaultSubCommand");
        this.init();
    }

    public final boolean isCommand(ShellToken token) {
        return this.isCommand(token.asString());
    }

    public final boolean isCommand(String token) {
        return this.mainCommands.containsKey(token);
    }

    public final MainCommandType determineCommand(ShellToken t) {
        if (this.isCommand(t)) {
            return this.mainCommands.get(t.asString());
        }
        throw new IllegalArgumentException(String.format("'%s' is not a command!", t.asString()));
    }

    public final boolean isSubCommand(ShellToken token) {
        return this.isSubCommand(token.asString());
    }

    public final boolean isSubCommand(String token) {
        return this.subCommands.containsKey(token);
    }

    public final SubCommandType determineSubCommand(ShellToken t) {
        if (this.isSubCommand(t)) {
            return this.subCommands.get(t.asString());
        }
        throw new IllegalArgumentException(String.format("'%s' is not a sub command!", t.asString()));
    }

    public final SubCommandType getDefaultSubCommand() {
        return this.defaultSubCommand;
    }

    protected abstract Class<? extends MainCommandType> getMainCommandType();

    private void initMainCommandMap() {
        Class<? extends MainCommandType> mainCommandTypes = this.getMainCommandType();
        if (!mainCommandTypes.isEnum()) {
            throw new IllegalArgumentException(String.format("Not an java.lang.Enum type returned by %s#getMainCommandType()!", this.getClass().getName()));
        }
        for (MainCommandType t : mainCommandTypes.getEnumConstants()) {
            this.mainCommands.put(t.getLiteral(), t);
        }
    }

    private void initSubCommandMap() {
        Class<? extends SubCommandType> subCommandTypes = this.getSubCommandType();
        if (!subCommandTypes.isEnum()) {
            throw new IllegalArgumentException(String.format("Not an java.lang.Enum type returned by %s#getSubCommandType()!", this.getClass().getName()));
        }
        for (SubCommandType t : subCommandTypes.getEnumConstants()) {
            if (t.getLiteral().isEmpty()) continue;
            this.subCommands.put(t.getLiteral(), t);
        }
    }

    protected abstract Class<? extends SubCommandType> getSubCommandType();

    private void init() {
        this.initMainCommandMap();
        this.initSubCommandMap();
    }
}

