/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.token;

import de.weltraumschaf.commons.guava.Objects;
import de.weltraumschaf.commons.validate.Validate;

public final class Position {
    public static final Position NULL = new Position(0, 0);
    private final String file;
    private final int line;
    private final int column;

    public Position(int line, int column) {
        this(line, column, "");
    }

    public Position(int line, int column, String file) {
        this.line = Validate.greaterThan((int)line, (int)-1, (String)"line");
        this.column = Validate.greaterThan((int)column, (int)-1, (String)"column");
        this.file = (String)Validate.notNull((Object)file, (String)"file");
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (!this.getFile().isEmpty()) {
            str.append(this.getFile()).append(' ');
        }
        str.append(String.format("(%s, %s)", this.getLine(), this.getColumn()));
        return str.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.line, this.column, this.file});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Position)) {
            return false;
        }
        Position other = (Position)obj;
        return Objects.equal((Object)this.line, (Object)other.line) && Objects.equal((Object)this.column, (Object)other.column) && Objects.equal((Object)this.file, (Object)other.file);
    }
}

