/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.token;

import de.weltraumschaf.commons.guava.Objects;
import de.weltraumschaf.commons.token.Position;
import de.weltraumschaf.commons.token.Token;
import de.weltraumschaf.commons.token.TokenType;
import de.weltraumschaf.commons.validate.Validate;

abstract class BaseToken<T>
implements Token {
    private final TokenType type;
    private final Position position;
    private final String raw;
    private final T value;

    public BaseToken(TokenType type, Position position, String raw, T value) {
        this.type = (TokenType)((Object)Validate.notNull((Object)((Object)type), (String)"type"));
        this.position = (Position)Validate.notNull((Object)position, (String)"position");
        this.raw = (String)Validate.notNull((Object)raw, (String)"raw");
        this.value = Validate.notNull(value, (String)"value");
    }

    @Override
    public final TokenType getType() {
        return this.type;
    }

    @Override
    public final Position getPosition() {
        return this.position;
    }

    @Override
    public final String getRaw() {
        return this.raw;
    }

    final T getValue() {
        return this.value;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.position, this.raw, this.value});
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof BaseToken)) {
            return false;
        }
        BaseToken other = (BaseToken)obj;
        return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.position, (Object)other.position) && Objects.equal((Object)this.raw, (Object)other.raw) && Objects.equal(this.value, other.value);
    }

    public final String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("position", (Object)this.position).add("raw", (Object)this.raw).add("value", this.value).toString();
    }

    @Override
    public String asString() {
        return this.value.toString();
    }

    static final class LiteralToken
    extends StringToken {
        public LiteralToken(Position position, String raw, String value) {
            super(TokenType.LITERAL, position, raw, value);
        }
    }

    static final class KeywordToken
    extends StringToken {
        public KeywordToken(Position position, String raw, String value) {
            super(TokenType.KEYWORD, position, raw, value);
        }
    }

    static class StringToken
    extends BaseToken<String> {
        public StringToken(Position position, String raw, String value) {
            this(TokenType.STRING, position, raw, value);
        }

        private StringToken(TokenType type, Position position, String raw, String value) {
            super(type, position, raw, value);
        }

        @Override
        public Boolean asBoolean() {
            return !((String)this.getValue()).isEmpty();
        }

        @Override
        public Float asFloat() {
            return Float.valueOf(((String)this.getValue()).isEmpty() ? 0.0f : 1.0f);
        }

        @Override
        public Integer asInteger() {
            return ((String)this.getValue()).isEmpty() ? 0 : 1;
        }
    }

    static final class FloatToken
    extends BaseToken<Float> {
        public FloatToken(Position position, String raw, Float value) {
            super(TokenType.FLOAT, position, raw, value);
        }

        @Override
        public Boolean asBoolean() {
            return ((Float)this.getValue()).floatValue() != 0.0f;
        }

        @Override
        public Float asFloat() {
            return (Float)this.getValue();
        }

        @Override
        public Integer asInteger() {
            return ((Float)this.getValue()).intValue();
        }
    }

    static final class IntegerToken
    extends BaseToken<Integer> {
        public IntegerToken(Position position, String raw, Integer value) {
            super(TokenType.INTEGER, position, raw, value);
        }

        @Override
        public Boolean asBoolean() {
            return (Integer)this.getValue() != 0;
        }

        @Override
        public Float asFloat() {
            return Float.valueOf((float)((Integer)this.getValue()).intValue() + 0.0f);
        }

        @Override
        public Integer asInteger() {
            return (Integer)this.getValue();
        }
    }

    static final class BooleanToken
    extends BaseToken<Boolean> {
        public BooleanToken(Position position, String raw, Boolean value) {
            super(TokenType.BOOLEAN, position, raw, value);
        }

        @Override
        public Boolean asBoolean() {
            return (Boolean)this.getValue();
        }

        @Override
        public Float asFloat() {
            return Float.valueOf((Boolean)this.getValue() != false ? 1.0f : 0.0f);
        }

        @Override
        public Integer asInteger() {
            return (Boolean)this.getValue() != false ? 1 : 0;
        }
    }
}

