/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

import de.weltraumschaf.commons.characters.CharacterHelper;
import de.weltraumschaf.commons.characters.CharacterStream;
import de.weltraumschaf.commons.guava.Lists;
import de.weltraumschaf.commons.shell.LiteralCommandMap;
import de.weltraumschaf.commons.shell.Scanner;
import de.weltraumschaf.commons.shell.SyntaxException;
import de.weltraumschaf.commons.token.Position;
import de.weltraumschaf.commons.token.Token;
import de.weltraumschaf.commons.token.Tokens;
import de.weltraumschaf.commons.validate.Validate;
import java.util.List;

class DefaultScanner
implements Scanner {
    private final LiteralCommandMap commandMap;

    public DefaultScanner(LiteralCommandMap commandMap) {
        this.commandMap = commandMap;
    }

    @Override
    public List<Token> scan(String line) throws SyntaxException {
        Validate.notNull((Object)line, (String)"line");
        List tokens = Lists.newArrayList();
        if (line.isEmpty()) {
            return tokens;
        }
        this.scan(tokens, new CharacterStream(line));
        return tokens;
    }

    private void scan(List<Token> tokens, CharacterStream characterStream) throws SyntaxException {
        while (characterStream.hasNext()) {
            char currentChar = characterStream.next();
            if (CharacterHelper.isSign(currentChar) && CharacterHelper.isNum(characterStream.peek())) {
                tokens.add(this.scanNumber(characterStream));
                continue;
            }
            if (CharacterHelper.isNum(currentChar)) {
                tokens.add(this.scanNumber(characterStream));
                continue;
            }
            if (CharacterHelper.isAlpha(currentChar) || CharacterHelper.isSpecialChar(currentChar)) {
                tokens.add(this.scanLiteral(characterStream));
                continue;
            }
            if (!CharacterHelper.isQuote(currentChar)) continue;
            tokens.add(this.scanString(characterStream));
        }
    }

    private Token scanLiteral(CharacterStream characterStream) {
        return this.scanLiteralOrKeyword(characterStream, new StringBuilder());
    }

    private Token scanLiteralOrKeyword(CharacterStream characterStream, StringBuilder value) {
        char currentChar;
        value.append(characterStream.current());
        while (characterStream.hasNext() && !CharacterHelper.isWhiteSpace(currentChar = characterStream.next())) {
            value.append(currentChar);
        }
        String tokenString = value.toString();
        if ("true".equals(tokenString) || "false".equals(tokenString)) {
            return Tokens.newBooleanToken(Position.NULL, tokenString, Boolean.parseBoolean(tokenString));
        }
        if (this.isKeyword(tokenString)) {
            return Tokens.newKeywordToken(Position.NULL, tokenString, tokenString);
        }
        return Tokens.newLiteralToken(Position.NULL, tokenString, tokenString);
    }

    private Token scanNumber(CharacterStream characterStream) {
        char currentChar;
        StringBuilder value = new StringBuilder();
        value.append(characterStream.current());
        while (characterStream.hasNext() && !CharacterHelper.isWhiteSpace(currentChar = characterStream.next())) {
            if ('.' == currentChar) {
                return this.scanFloat(characterStream, value);
            }
            if (!CharacterHelper.isNum(currentChar)) {
                return this.scanLiteralOrKeyword(characterStream, value);
            }
            value.append(currentChar);
        }
        String literal = value.toString();
        return Tokens.newIntegerToken(Position.NULL, literal, Integer.valueOf(literal));
    }

    private Token scanFloat(CharacterStream characterStream, StringBuilder value) {
        char currentChar;
        value.append(characterStream.current());
        while (characterStream.hasNext() && !CharacterHelper.isWhiteSpace(currentChar = characterStream.next())) {
            if (!CharacterHelper.isNum(currentChar) && !this.isAllowedInFloat(currentChar)) {
                return this.scanLiteralOrKeyword(characterStream, value);
            }
            value.append(currentChar);
        }
        String literal = value.toString();
        return Tokens.newFloatToken(Position.NULL, literal, Float.valueOf(literal));
    }

    private Token scanString(CharacterStream characterStream) throws SyntaxException {
        StringBuilder value = new StringBuilder();
        char startQuote = characterStream.current();
        boolean terminated = false;
        while (characterStream.hasNext()) {
            char currentChar = characterStream.next();
            if (currentChar == startQuote) {
                terminated = true;
                if (!characterStream.hasNext()) break;
                characterStream.next();
                break;
            }
            value.append(currentChar);
        }
        if (!terminated) {
            throw new SyntaxException(String.format("Unterminated string '%s'!", value.toString()));
        }
        return Tokens.newStringToken(Position.NULL, value.toString(), value.toString());
    }

    private boolean isKeyword(String token) {
        return this.commandMap.isCommand(token) || this.commandMap.isSubCommand(token);
    }

    private boolean isAllowedInFloat(char c) {
        return CharacterHelper.isSign(c) || 'e' == c || 'E' == c;
    }
}

