/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

import de.weltraumschaf.commons.guava.Lists;
import de.weltraumschaf.commons.shell.CommandVerifier;
import de.weltraumschaf.commons.shell.LiteralCommandMap;
import de.weltraumschaf.commons.shell.MainCommandType;
import de.weltraumschaf.commons.shell.Parser;
import de.weltraumschaf.commons.shell.Scanner;
import de.weltraumschaf.commons.shell.ShellCommand;
import de.weltraumschaf.commons.shell.SubCommandType;
import de.weltraumschaf.commons.shell.SyntaxException;
import de.weltraumschaf.commons.token.Token;
import de.weltraumschaf.commons.token.TokenType;
import de.weltraumschaf.commons.validate.Validate;
import java.util.List;

class DefaultParser
implements Parser {
    private final Scanner scanner;
    private final CommandVerifier verifier;
    private final LiteralCommandMap commandMap;

    public DefaultParser(Scanner scanner, CommandVerifier verifier, LiteralCommandMap commandMap) {
        this.scanner = (Scanner)Validate.notNull((Object)scanner, (String)"scanner");
        this.verifier = (CommandVerifier)Validate.notNull((Object)verifier, (String)"verifier");
        this.commandMap = (LiteralCommandMap)Validate.notNull((Object)commandMap, (String)"commandMap");
    }

    @Override
    public ShellCommand parse(String input) throws SyntaxException {
        Token secondToken;
        List<Token> tokens = this.scanner.scan(input);
        Token commandtoken = tokens.get(0);
        if (TokenType.KEYWORD != commandtoken.getType()) {
            throw new SyntaxException("Command expected as first input!");
        }
        MainCommandType command = this.commandMap.determineCommand(commandtoken);
        SubCommandType subCommand = this.commandMap.getDefaultSubCommand();
        int argumentBegin = 1;
        if (tokens.size() > 1 && (secondToken = tokens.get(1)).getType() == TokenType.KEYWORD) {
            Token keyword = secondToken;
            if (!this.commandMap.isSubCommand(keyword)) {
                throw new SyntaxException(String.format("Command '%s' followed by bad keyword '%s' as sub command!", commandtoken.asString(), secondToken.asString()));
            }
            ++argumentBegin;
            subCommand = this.commandMap.determineSubCommand(keyword);
        }
        List<Token> arguments = tokens.size() > argumentBegin ? tokens.subList(argumentBegin, tokens.size()) : Lists.newArrayList();
        ShellCommand cmd = new ShellCommand(command, subCommand, arguments);
        this.verifier.verifyCommand(cmd);
        return cmd;
    }
}

