/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

import de.weltraumschaf.commons.guava.Lists;
import de.weltraumschaf.commons.guava.Objects;
import de.weltraumschaf.commons.shell.MainCommandType;
import de.weltraumschaf.commons.shell.SubCommandType;
import de.weltraumschaf.commons.token.Token;
import de.weltraumschaf.commons.validate.Validate;
import java.util.Collections;
import java.util.List;

public class ShellCommand {
    private final MainCommandType mainCommand;
    private final SubCommandType subCommand;
    private final List<Token> arguments;

    public ShellCommand(MainCommandType mainCommand, SubCommandType subCommand, List<Token> arguments) {
        this.mainCommand = (MainCommandType)Validate.notNull((Object)mainCommand, (String)"mainCommand");
        this.subCommand = (SubCommandType)Validate.notNull((Object)subCommand, (String)"subCommand");
        this.arguments = Lists.newArrayList((Iterable)((Iterable)Validate.notNull(arguments, (String)"arguments")));
    }

    public MainCommandType getMainCommand() {
        return this.mainCommand;
    }

    public SubCommandType getSubCommand() {
        return this.subCommand;
    }

    public List<Token> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mainCommand", (Object)this.mainCommand).add("subCommand", (Object)this.subCommand).add("arguments", this.arguments).toString();
    }
}

