/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.token;

import de.weltraumschaf.commons.guava.Objects;
import de.weltraumschaf.commons.token.Position;
import de.weltraumschaf.commons.token.Token;
import de.weltraumschaf.commons.token.TokenType;
import de.weltraumschaf.commons.validate.Validate;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;

abstract class BaseToken<T>
implements Token {
    private static final String FORMAT = "Token is not of type %s! But is of type %s.";
    private final TokenType type;
    private final Position position;
    private final String raw;
    private final T value;

    public BaseToken(TokenType type, Position position, String raw, T value) {
        this.type = (TokenType)((Object)Validate.notNull((Object)((Object)type), (String)"type"));
        this.position = (Position)Validate.notNull((Object)position, (String)"position");
        this.raw = (String)Validate.notNull((Object)raw, (String)"raw");
        this.value = Validate.notNull(value, (String)"value");
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getRaw() {
        return this.raw;
    }

    T getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.position, this.raw, this.value});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseToken)) {
            return false;
        }
        BaseToken other = (BaseToken)obj;
        return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.position, (Object)other.position) && Objects.equal((Object)this.raw, (Object)other.raw) && Objects.equal(this.value, other.value);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("position", (Object)this.position).add("raw", (Object)this.raw).add("value", this.value).toString();
    }

    @Override
    public String asString() {
        return this.value.toString();
    }

    protected void raiseUnsupportedValueOperationError(TokenType unsupported) {
        throw new UnsupportedOperationException(String.format(FORMAT, new Object[]{unsupported, this.getType()}));
    }

    static final class LiteralToken
    extends StringToken {
        public LiteralToken(Position position, String raw, String value) {
            super(TokenType.LITERAL, position, raw, value);
        }
    }

    static final class KeywordToken
    extends StringToken {
        public KeywordToken(Position position, String raw, String value) {
            super(TokenType.KEYWORD, position, raw, value);
        }
    }

    static class StringToken
    extends BaseToken<String> {
        public StringToken(Position position, String raw, String value) {
            this(TokenType.STRING, position, raw, value);
        }

        private StringToken(TokenType type, Position position, String raw, String value) {
            super(type, position, raw, value);
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Boolean asBoolean() {
            this.raiseUnsupportedValueOperationError(TokenType.BOOLEAN);
            return null;
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Float asFloat() {
            this.raiseUnsupportedValueOperationError(TokenType.FLOAT);
            return null;
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Integer asInteger() {
            this.raiseUnsupportedValueOperationError(TokenType.INTEGER);
            return null;
        }
    }

    static final class FloatToken
    extends BaseToken<Float> {
        public FloatToken(Position position, String raw, Float value) {
            super(TokenType.FLOAT, position, raw, value);
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Boolean asBoolean() {
            this.raiseUnsupportedValueOperationError(TokenType.BOOLEAN);
            return null;
        }

        @Override
        public Float asFloat() {
            return (Float)this.getValue();
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Integer asInteger() {
            this.raiseUnsupportedValueOperationError(TokenType.INTEGER);
            return null;
        }
    }

    static final class IntegerToken
    extends BaseToken<Integer> {
        public IntegerToken(Position position, String raw, Integer value) {
            super(TokenType.INTEGER, position, raw, value);
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Boolean asBoolean() {
            this.raiseUnsupportedValueOperationError(TokenType.BOOLEAN);
            return null;
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Float asFloat() {
            this.raiseUnsupportedValueOperationError(TokenType.FLOAT);
            return null;
        }

        @Override
        public Integer asInteger() {
            return (Integer)this.getValue();
        }
    }

    static final class BooleanToken
    extends BaseToken<Boolean> {
        public BooleanToken(Position position, String raw, Boolean value) {
            super(TokenType.BOOLEAN, position, raw, value);
        }

        @Override
        public Boolean asBoolean() {
            return (Boolean)this.getValue();
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Float asFloat() {
            this.raiseUnsupportedValueOperationError(TokenType.FLOAT);
            return null;
        }

        @Override
        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Return never reached, because exception thrown before.")
        public Integer asInteger() {
            this.raiseUnsupportedValueOperationError(TokenType.INTEGER);
            return null;
        }
    }
}

