/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.characters;

import de.weltraumschaf.commons.guava.Sets;
import java.util.Set;

public final class CharacterHelper {
    private static final Set<Character> SPECIAL_CHARS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('-')});
    private static final Set<Character> OPERATORS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('^'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('='), Character.valueOf(':'), Character.valueOf('?'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('!'), Character.valueOf('~'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$')});
    private static final Set<Character> SIGN_CHARS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('+'), Character.valueOf('-')});

    private CharacterHelper() {
        throw new UnsupportedOperationException("Don't call via reflection!");
    }

    public static boolean isCharInRange(char character, char start, char end) {
        if (end < start) {
            throw new IllegalArgumentException("End must be greater or equal than start!");
        }
        return start <= character && character <= end;
    }

    public static boolean isAlpha(char character) {
        return CharacterHelper.isCharInRange(character, 'a', 'z') || CharacterHelper.isCharInRange(character, 'A', 'Z');
    }

    public static boolean isNum(char character) {
        return CharacterHelper.isCharInRange(character, '0', '9');
    }

    public static boolean isAlphaNum(char character) {
        return CharacterHelper.isAlpha(character) || CharacterHelper.isNum(character);
    }

    public static boolean isWhiteSpace(char character) {
        return ' ' == character || '\t' == character || '\n' == character || '\r' == character;
    }

    public static boolean isQuote(char character) {
        return CharacterHelper.isSingleQuote(character) || CharacterHelper.isDoubleQuote(character);
    }

    public static boolean isSingleQuote(char character) {
        return '\'' == character;
    }

    public static boolean isDoubleQuote(char character) {
        return '\"' == character;
    }

    public static boolean isSpecialChar(char character) {
        return SPECIAL_CHARS.contains(Character.valueOf(character));
    }

    public static boolean isOperator(char character) {
        return OPERATORS.contains(Character.valueOf(character));
    }

    public static boolean isSign(char character) {
        return SIGN_CHARS.contains(Character.valueOf(character));
    }
}

