/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.jcommander;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import de.weltraumschaf.commons.validate.Validate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class JCommanderImproved<O> {
    private static final int LEFT_COL_WIDTH = 22;
    private static final int AVAILABLE_WIDTH = 80;
    private static final String DEFAULT_NEW_LINE = String.format("%n", new Object[0]);
    private JCommander optionsParser = new JCommander();
    private final Class<O> optionsType;
    private final String programName;

    public JCommanderImproved(String programName, Class<O> optionsType) {
        this.programName = Validate.notEmpty((String)programName, (String)"programName");
        this.optionsParser.setProgramName(programName);
        this.optionsType = (Class)Validate.notNull(optionsType, (String)"optionsType");
        JCommanderImproved.createOptions(optionsType);
    }

    public O gatherOptions(String[] args) {
        O opts = JCommanderImproved.createOptions(this.optionsType);
        this.reset();
        this.optionsParser.addObject(opts);
        this.optionsParser.parse((String[])Validate.notNull((Object)args, (String)"args"));
        return opts;
    }

    public String helpMessage(String usage, String descriptions, String example) {
        Validate.notNull((Object)usage, (String)"usage");
        Validate.notNull((Object)descriptions, (String)"descriptions");
        Validate.notNull((Object)example, (String)"example");
        this.reset();
        String indent = "  ";
        StringBuilder help = new StringBuilder();
        help.append("Usage: ").append(this.programName);
        if (!usage.trim().isEmpty()) {
            help.append(' ').append(usage.trim());
        }
        help.append(DEFAULT_NEW_LINE).append(DEFAULT_NEW_LINE);
        if (!descriptions.trim().isEmpty()) {
            help.append(descriptions.trim()).append(DEFAULT_NEW_LINE);
        }
        if (this.optionsParser.getParameters().isEmpty()) {
            this.gatherOptions(new String[0]);
        }
        List parameters = this.optionsParser.getParameters();
        Collections.sort(parameters, new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription o1, ParameterDescription o2) {
                return o1.getLongestName().compareTo(o2.getLongestName());
            }
        });
        if (!parameters.isEmpty()) {
            help.append(DEFAULT_NEW_LINE).append("Options").append(DEFAULT_NEW_LINE).append(DEFAULT_NEW_LINE);
            int leftColumnWidth = 22;
            int rightColumnwidth = 58;
            for (ParameterDescription parameter : parameters) {
                help.append(JCommanderImproved.rightPad("  " + parameter.getNames(), 22)).append(JCommanderImproved.lineBreak(parameter.getDescription(), 58, 22)).append(DEFAULT_NEW_LINE);
            }
        }
        help.append(DEFAULT_NEW_LINE);
        if (!example.trim().isEmpty()) {
            help.append("Example").append(DEFAULT_NEW_LINE).append(DEFAULT_NEW_LINE).append("  ").append(example.trim()).append(DEFAULT_NEW_LINE);
        }
        help.append(DEFAULT_NEW_LINE);
        return help.toString();
    }

    static String rightPad(String in, int length) {
        Validate.greaterThanOrEqual((int)length, (int)0, (String)"length");
        if (null == in) {
            return JCommanderImproved.spaces(length);
        }
        if (length - in.length() == 0) {
            return in;
        }
        return in + JCommanderImproved.spaces(length - in.length());
    }

    static String spaces(int length) {
        if (length < 1) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(" ");
        for (int i = 1; i < length; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    static String lineBreak(String in, int length, int leftPadLength) {
        if (null == in) {
            return "";
        }
        Validate.greaterThanOrEqual((int)length, (int)0, (String)"length");
        Validate.greaterThanOrEqual((int)leftPadLength, (int)0, (String)"leftPadLength");
        if (in.length() <= length) {
            return in;
        }
        StringBuilder sb = new StringBuilder(in);
        int i = 0;
        while ((i = sb.indexOf(" ", i + length)) != -1) {
            sb.replace(i, i + 1, DEFAULT_NEW_LINE);
        }
        return sb.toString().replace(DEFAULT_NEW_LINE, DEFAULT_NEW_LINE + JCommanderImproved.spaces(leftPadLength));
    }

    private void reset() {
        this.optionsParser = new JCommander();
    }

    private static <O> O createOptions(Class<O> optionsType) {
        try {
            return optionsType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }
}

