/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.jcommander;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import de.weltraumschaf.commons.validate.Validate;
import java.util.List;

public final class JCommanderImproved<O> {
    private static final String DEFAULT_NEW_LINE = String.format("%n", new Object[0]);
    private final JCommander optionsParser = new JCommander();
    private final Class<O> optionsType;
    private final String programName;

    public JCommanderImproved(String programName, Class<O> optionsType) {
        this.programName = Validate.notEmpty((String)programName, (String)"programName");
        this.optionsParser.setProgramName(programName);
        this.optionsType = (Class)Validate.notNull(optionsType, (String)"optionsType");
        JCommanderImproved.createOptions(optionsType);
    }

    private static <O> O createOptions(Class<O> optionsType) {
        try {
            return optionsType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    public O gatherOptions(String[] args) {
        O opts = JCommanderImproved.createOptions(this.optionsType);
        this.optionsParser.addObject(opts);
        this.optionsParser.parse(args);
        return opts;
    }

    public String helpMessage(String usage, String descriptions, String example) {
        String indent = "  ";
        StringBuilder help = new StringBuilder();
        help.append("Usage: ").append(this.programName).append(' ').append(usage).append(DEFAULT_NEW_LINE).append(DEFAULT_NEW_LINE).append(descriptions).append(DEFAULT_NEW_LINE);
        List parameters = this.optionsParser.getParameters();
        if (!parameters.isEmpty()) {
            help.append(DEFAULT_NEW_LINE).append("Options").append(DEFAULT_NEW_LINE).append(DEFAULT_NEW_LINE);
            int leftColumnWidth = 22;
            int rightColumnwidth = 58;
            for (ParameterDescription parameter : parameters) {
                help.append(JCommanderImproved.pad("  " + parameter.getNames(), 22)).append(JCommanderImproved.lineBreak(parameter.getDescription(), 58, 22)).append(DEFAULT_NEW_LINE);
            }
        }
        help.append(DEFAULT_NEW_LINE).append("Example").append(DEFAULT_NEW_LINE).append(DEFAULT_NEW_LINE).append("  " + example).append(DEFAULT_NEW_LINE).append(DEFAULT_NEW_LINE);
        return help.toString();
    }

    static String pad(String in, int length) {
        if (null == in) {
            return JCommanderImproved.spaces(length);
        }
        return in + JCommanderImproved.spaces(length - in.length());
    }

    static String spaces(int length) {
        if (length < 1) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(" ");
        for (int i = 1; i < length; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    static String lineBreak(String in, int length, int leftPadLength) {
        if (null == in) {
            return "";
        }
        if (in.length() <= length) {
            return in;
        }
        StringBuilder sb = new StringBuilder(in);
        int i = 0;
        while ((i = sb.indexOf(" ", i + length)) != -1) {
            sb.replace(i, i + 1, DEFAULT_NEW_LINE.toString());
        }
        return sb.toString().replace(DEFAULT_NEW_LINE.toString(), DEFAULT_NEW_LINE.toString() + JCommanderImproved.spaces(leftPadLength));
    }
}

