/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.guava;

import de.weltraumschaf.commons.guava.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class Lists {
    private Lists() {
        throw new UnsupportedOperationException("Constructor must not be called by reflection!");
    }

    public static <E> List<E> newArrayList() {
        return new ArrayList();
    }

    private static <T> Collection<T> cast(Iterable<T> iterable) {
        return (Collection)iterable;
    }

    public static <E> List<E> newArrayList(Iterable<? extends E> elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements instanceof Collection) {
            return new ArrayList<E>(Lists.cast(elements));
        }
        return Lists.newArrayList(elements.iterator());
    }

    public static <E> List<E> newArrayList(Iterator<? extends E> elements) {
        List<E> list = Lists.newArrayList();
        Iterators.addAll(list, elements);
        return list;
    }

    @SafeVarargs
    public static <E> List<E> newArrayList(E ... elements) {
        List<E> list = Lists.newArrayList();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }
}

