/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.guava;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Sets {
    private static final int THIRD = 3;

    private Sets() {
        throw new UnsupportedOperationException("Constructor must not be called by reflection!");
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            if (expectedSize < 0) {
                throw new IllegalArgumentException("Parameter 'expectedSize' must not be negative!");
            }
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return expectedSize + expectedSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <E> Set<E> newHashSet(E ... elements) {
        Set<E> set = Sets.newHashSetWithExpectedSize(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> Set<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(Sets.capacity(expectedSize));
    }

    public static <E> SortedSet<E> newTreeSet() {
        return new TreeSet();
    }
}

