/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.experimental;

import de.weltraumschaf.commons.validate.Validate;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SoftCache<K, V> {
    private final Map<K, SoftReference<V>> data = new ConcurrentHashMap<K, SoftReference<V>>();
    private Finder<K, V> finder = new NullFinder();

    public V get(K key) {
        if (null == key) {
            throw new NullPointerException("Parameter 'key' must not be null!");
        }
        SoftReference<V> reference = this.data.get(key);
        if (null == reference || null == reference.get()) {
            V value = this.finder.find(key);
            if (null == value) {
                throw new NullPointerException(String.format("No value fond for key '%s'!", key));
            }
            this.add(key, value);
            return value;
        }
        return reference.get();
    }

    public void add(K key, V value) {
        Validate.notNull(key, (String)"key");
        Validate.notNull(value, (String)"value");
        SoftReference<V> reference = this.data.put(key, new SoftReference<V>(value));
        if (null != reference) {
            reference.clear();
        }
    }

    public void remove(K key) {
        if (null == key) {
            throw new NullPointerException("Parameter 'key' must not be null!");
        }
        SoftReference<V> reference = this.data.remove(key);
        if (null != reference) {
            reference.clear();
        }
    }

    public void finder(Finder<K, V> f) {
        this.finder = (Finder)Validate.notNull(f, (String)"f");
    }

    private static final class NullFinder<K, V>
    implements Finder<K, V> {
        private NullFinder() {
        }

        @Override
        public V find(K key) {
            return null;
        }
    }

    public static interface Finder<K, V> {
        public V find(K var1);
    }
}

