/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.config;

import de.weltraumschaf.commons.validate.Validate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;

public abstract class ReloadingPropertiesConfiguration {
    private final Properties properties = new Properties();
    private final Path configFile;
    private long lastLoad = -1L;

    public ReloadingPropertiesConfiguration(String filename) {
        this(new File(Validate.notEmpty((String)filename, (String)"filename")));
    }

    public ReloadingPropertiesConfiguration(File file) {
        this(file.toPath());
    }

    public ReloadingPropertiesConfiguration(Path file) {
        this.configFile = (Path)Validate.notNull((Object)file, (String)"file");
    }

    public final String getProperty(String propertyName, String defaultValue) {
        Validate.notNull((Object)defaultValue, (String)"defaultValue");
        String result = this.getProperty(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public final String getRequiredProperty(String propertyName) {
        String result = this.getProperty(propertyName);
        if (result == null) {
            throw new RuntimeException(String.format("Missing property with name '%s'!", propertyName));
        }
        return result;
    }

    public final boolean getFlag(String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(this.getProperty(propertyName, String.valueOf(defaultValue)));
    }

    public final int getInteger(String propertyName, int defaultValue) {
        return Integer.parseInt(this.getProperty(propertyName, String.valueOf(defaultValue)), 10);
    }

    private String getProperty(String propertyName) {
        this.ensureConfigurationIsFresh();
        return this.properties.getProperty(Validate.notEmpty((String)propertyName, (String)"propertyName"));
    }

    private synchronized void ensureConfigurationIsFresh() {
        try {
            long lastModified = Files.getLastModifiedTime(this.configFile, new LinkOption[0]).toMillis();
            if (this.lastLoad > lastModified) {
                return;
            }
            this.lastLoad = lastModified;
            try (FileInputStream inputStream = new FileInputStream(this.configFile.toFile());){
                this.properties.clear();
                this.properties.load(inputStream);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Failed to load configuration file '%s'!", this.configFile), ex);
        }
    }
}

