/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.concurrent;

import de.weltraumschaf.commons.concurrent.Queue;
import de.weltraumschaf.commons.guava.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class ConcurrentQueue<E>
implements Queue<E> {
    private final AtomicReference<Entry<E>> head = new AtomicReference();
    private final AtomicReference<Entry<E>> tail = new AtomicReference();

    ConcurrentQueue() {
    }

    @Override
    public boolean isEmpty() {
        return null == this.head.get() && null == this.tail.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(E element) {
        Entry<E> node = new Entry<E>(element);
        while (true) {
            if (null == this.head.get()) {
                if (!this.head.compareAndSet(null, node)) continue;
                return;
            }
            Entry<E> currentTail = this.tail.get();
            if (null == currentTail) {
                Entry<E> currentHead = this.head.get();
                ((Entry)currentHead).next = (Entry)node;
                if (!this.tail.compareAndSet(null, node) || !this.head.compareAndSet(currentHead, currentHead)) continue;
                return;
            }
            ((Entry)currentTail).next = (Entry)node;
            if (this.tail.compareAndSet(currentTail, node)) return;
        }
    }

    @Override
    public E get() {
        Entry<E> currentHead;
        do {
            if (null != (currentHead = this.head.get())) continue;
            return null;
        } while (!(null == ((Entry)currentHead).next ? this.head.compareAndSet(currentHead, ((Entry)currentHead).next) && this.tail.compareAndSet(this.tail.get(), null) : this.head.compareAndSet(currentHead, ((Entry)currentHead).next)));
        return (E)((Entry)currentHead).value;
    }

    public int hashCode() {
        Entry<E> currentTop = this.head.get();
        if (null == currentTop) {
            return 0;
        }
        return currentTop.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConcurrentQueue)) {
            return false;
        }
        ConcurrentQueue other = (ConcurrentQueue)obj;
        return Objects.equal(this.head.get(), other.head.get()) && Objects.equal(this.tail.get(), other.tail.get());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append('[');
        Entry element = this.head.get();
        boolean first = true;
        while (null != element) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(element.value);
            element = element.next;
            first = false;
        }
        return buffer.append(']').toString();
    }

    private static final class Entry<T> {
        private final T value;
        private Entry<T> next;

        Entry(T element) {
            this.value = element;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value, this.next});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equal(this.value, other.value) && Objects.equal(this.next, other.next);
        }
    }
}

