/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.concurrent;

import de.weltraumschaf.commons.concurrent.Stack;
import de.weltraumschaf.commons.guava.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class ConcurrentStack<E>
implements Stack<E> {
    private final AtomicReference<Entry<E>> top = new AtomicReference();

    ConcurrentStack() {
    }

    @Override
    public boolean isEmpty() {
        return null == this.top.get();
    }

    @Override
    public E peek() {
        Entry<E> currentTop = this.top.get();
        return (E)(null == currentTop ? null : ((Entry)currentTop).value);
    }

    @Override
    public E pop() {
        Entry<E> currentTop;
        do {
            if (null != (currentTop = this.top.get())) continue;
            return null;
        } while (!this.top.compareAndSet(currentTop, ((Entry)currentTop).next));
        return (E)((Entry)currentTop).value;
    }

    @Override
    public void push(E element) {
        Entry<E> currentTop;
        while (!this.top.compareAndSet(currentTop = this.top.get(), new Entry<E>(element, currentTop))) {
        }
    }

    public int hashCode() {
        Entry<E> currentTop = this.top.get();
        if (null == currentTop) {
            return 0;
        }
        return currentTop.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConcurrentStack)) {
            return false;
        }
        ConcurrentStack other = (ConcurrentStack)obj;
        return Objects.equal(this.top.get(), other.top.get());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append('[');
        Entry element = this.top.get();
        boolean first = true;
        while (null != element) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(element.value);
            element = element.next;
            first = false;
        }
        return buffer.append(']').toString();
    }

    private static final class Entry<T> {
        private final T value;
        private final Entry<T> next;

        Entry(T element, Entry<T> next) {
            this.value = element;
            this.next = next;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value, this.next});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equal(this.value, other.value) && Objects.equal(this.next, other.next);
        }
    }
}

