/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.application;

import de.weltraumschaf.commons.validate.Validate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShutDownHook
extends Thread {
    private static final Logger DEFAULT_LOGGER = Logger.getLogger(ShutDownHook.class.getName());
    private final Set<Callable<Void>> callbacks = new HashSet<Callable<Void>>();
    private final Logger logger;

    public ShutDownHook() {
        this(DEFAULT_LOGGER);
    }

    public ShutDownHook(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void run() {
        Iterator<Callable<Void>> iterator = this.callbacks.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().call();
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Exception thrown by running a callback!", ex);
            }
        }
    }

    public ShutDownHook register(final Runnable callback) {
        Validate.notNull((Object)callback, (String)"callback");
        return this.register(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                callback.run();
                return null;
            }
        });
    }

    public ShutDownHook register(Callable<Void> callback) {
        this.callbacks.add((Callable<Void>)Validate.notNull(callback, (String)"callback"));
        return this;
    }
}

