/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.token;

import de.weltraumschaf.commons.Null;
import de.weltraumschaf.commons.token.Position;
import de.weltraumschaf.commons.token.Token;
import de.weltraumschaf.commons.token.TokenType;

public final class Tokens {
    private static final Position NULL_POSITION = new Position(0, 0);

    private Tokens() {
    }

    public static Token<String> newOperatorToken(String value) {
        return Tokens.newOperatorToken(value, NULL_POSITION);
    }

    public static Token<String> newOperatorToken(String value, Position pos) {
        return new Token<String>(TokenType.OPERATOR, value, pos);
    }

    public static Token<Null> newEndOfFileToken() {
        return Tokens.newEndOfFileToken(NULL_POSITION);
    }

    public static Token<Null> newEndOfFileToken(Position pos) {
        return new Token<Null>(TokenType.EOF, Null.getInstance(), pos);
    }

    public static Token<String> newKeywordToken(String value) {
        return Tokens.newKeywordToken(value, NULL_POSITION);
    }

    public static Token<String> newKeywordToken(String value, Position pos) {
        return new Token<String>(TokenType.KEYWORD, value, pos);
    }

    public static Token<Integer> newIntegerToken(Integer value) {
        return Tokens.newIntegerToken(value, NULL_POSITION);
    }

    public static Token<Integer> newIntegerToken(Integer value, Position pos) {
        return new Token<Integer>(TokenType.INTEGER, value, pos);
    }

    public static Token<Float> newFloatToken(Float value) {
        return Tokens.newFloatToken(value, NULL_POSITION);
    }

    public static Token<Float> newFloatToken(Float value, Position pos) {
        return new Token<Float>(TokenType.FLOAT, value, pos);
    }

    public static Token<String> newCommentToken(String value) {
        return Tokens.newCommentToken(value, NULL_POSITION);
    }

    public static Token<String> newCommentToken(String value, Position pos) {
        return new Token<String>(TokenType.COMMENT, value, pos);
    }

    public static Token<Null> newEndOfLineToken() {
        return Tokens.newEndOfLineToken(NULL_POSITION);
    }

    public static Token<Null> newEndOfLineToken(Position pos) {
        return new Token<Null>(TokenType.EOL, Null.getInstance(), pos);
    }

    public static Token<Boolean> newBooleanToken(Boolean value) {
        return Tokens.newBooleanToken(value, NULL_POSITION);
    }

    public static Token<Boolean> newBooleanToken(Boolean value, Position pos) {
        return new Token<Boolean>(TokenType.BOOLEAN, value, pos);
    }

    public static Token<Null> newNullToken() {
        return Tokens.newNullToken(NULL_POSITION);
    }

    public static Token<Null> newNullToken(Position pos) {
        return new Token<Null>(TokenType.NULL, Null.getInstance(), pos);
    }

    public static Token<String> newLiteralToken(String value) {
        return new Token<String>(TokenType.LITERAL, value, NULL_POSITION);
    }

    public static Token<String> newLiteralToken(String value, Position pos) {
        return new Token<String>(TokenType.LITERAL, value, pos);
    }

    public static Token<String> newStringToken(String value) {
        return Tokens.newStringToken(value, NULL_POSITION);
    }

    public static Token<String> newStringToken(String value, Position pos) {
        return new Token<String>(TokenType.STRING, value, pos);
    }
}

