/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.token;

import de.weltraumschaf.commons.guava.Objects;

public final class Position {
    private final String file;
    private final int line;
    private final int column;

    public Position(int line, int column) {
        this(line, column, "");
    }

    public Position(int line, int column, String file) {
        this.line = line;
        this.column = column;
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (!this.getFile().isEmpty()) {
            str.append(this.getFile()).append(' ');
        }
        str.append(String.format("(%s, %s)", this.getLine(), this.getColumn()));
        return str.toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.line, this.column, this.file);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Position)) {
            return false;
        }
        Position other = (Position)obj;
        return Objects.equal(this.line, other.line) && Objects.equal(this.column, other.column) && Objects.equal(this.file, other.file);
    }
}

