/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.system;

import de.weltraumschaf.commons.system.OperatingSystem;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public final class BrowserLauncher {
    private static final String WINDOWS_CMD = "cmd /c start";
    private static final String MAC_OS_CMD = "open";
    private static final String GNU_X_WWW_BROWSER_CMD = "x-www-browser";
    private static final String GNU_FIREFOX_CMD = "firefox";
    private static final String GNU_MOZILLA_CMD = "mozilla";
    private static final String GNU_KONQUEROR_CMD = "konqueror";
    private final OperatingSystem os;
    private final Runtime runtime;

    public BrowserLauncher() {
        this(OperatingSystem.determine(System.getProperty("os.name", "")), Runtime.getRuntime());
    }

    public BrowserLauncher(OperatingSystem os, Runtime runtime) {
        this.os = os;
        this.runtime = runtime;
    }

    private boolean openLinuxBrowser(String url) {
        boolean isDefaultKonqueror = false;
        try {
            File file;
            String canonical;
            Process process = this.execCommand("which", GNU_X_WWW_BROWSER_CMD);
            BufferedInputStream ins = new BufferedInputStream(process.getInputStream());
            BufferedReader bufreader = new BufferedReader(new InputStreamReader(ins));
            String defaultLinkPath = bufreader.readLine();
            ins.close();
            bufreader.close();
            if (defaultLinkPath != null && (canonical = (file = new File(defaultLinkPath)).getCanonicalPath()).indexOf(GNU_KONQUEROR_CMD) != -1) {
                isDefaultKonqueror = true;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!isDefaultKonqueror) {
            try {
                this.execCommand(GNU_X_WWW_BROWSER_CMD, url);
                return true;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        try {
            this.execCommand(GNU_FIREFOX_CMD, url);
            return true;
        }
        catch (IOException ex) {
            try {
                this.execCommand(GNU_MOZILLA_CMD, url);
                return true;
            }
            catch (IOException ex2) {
                try {
                    this.execCommand(GNU_KONQUEROR_CMD, url);
                    return true;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
    }

    private boolean openMacBrowser(String url) {
        try {
            this.execCommand(MAC_OS_CMD, url);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean openWindowsBrowser(String url) {
        try {
            this.execCommand(WINDOWS_CMD, url);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void openBrowser(String url) {
        boolean started = false;
        switch (this.os) {
            case LINUX: {
                started = this.openLinuxBrowser(url);
                break;
            }
            case MACOSX: {
                started = this.openMacBrowser(url);
                break;
            }
            case WINDOWS: {
                started = this.openWindowsBrowser(url);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported OS. Please go to " + url);
            }
        }
        if (!started) {
            throw new RuntimeException("Failed to open browser. Please go to " + url);
        }
    }

    private Process execCommand(String cmd, String argument) throws IOException {
        return this.runtime.exec(String.format("%s %s", cmd, argument));
    }
}

