/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

import de.weltraumschaf.commons.characters.CharacterHelper;
import de.weltraumschaf.commons.characters.CharacterStream;
import de.weltraumschaf.commons.guava.Lists;
import de.weltraumschaf.commons.shell.LiteralCommandMap;
import de.weltraumschaf.commons.shell.Scanner;
import de.weltraumschaf.commons.shell.SyntaxException;
import de.weltraumschaf.commons.token.Token;
import de.weltraumschaf.commons.token.Tokens;
import java.util.ArrayList;
import java.util.List;

class DefaultScanner
implements Scanner {
    private final LiteralCommandMap commandMap;

    public DefaultScanner(LiteralCommandMap commandMap) {
        this.commandMap = commandMap;
    }

    @Override
    public List<Token> scan(String line) throws SyntaxException {
        if (null == line) {
            throw new IllegalArgumentException("Line must not be null!");
        }
        ArrayList<Token> tokens = Lists.newArrayList();
        if (!line.isEmpty()) {
            this.scan(tokens, new CharacterStream(line));
        }
        return tokens;
    }

    private void scan(List<Token> tokens, CharacterStream characterStream) throws SyntaxException {
        while (characterStream.hasNext()) {
            char currentChar = characterStream.next();
            if (CharacterHelper.isAlpha(currentChar) || CharacterHelper.isSpecialChar(currentChar)) {
                tokens.add(this.scanLiteral(characterStream));
                continue;
            }
            if (CharacterHelper.isNum(currentChar)) {
                tokens.add(this.scanNumber(characterStream));
                continue;
            }
            if (!CharacterHelper.isQuote(currentChar)) continue;
            tokens.add(this.scanString(characterStream));
        }
    }

    private Token scanLiteral(CharacterStream characterStream) {
        char currentChar;
        StringBuilder value = new StringBuilder();
        value.append(characterStream.current());
        while (characterStream.hasNext() && !CharacterHelper.isWhiteSpace(currentChar = characterStream.next())) {
            value.append(currentChar);
        }
        String tokenString = value.toString();
        if (this.isKeyword(tokenString)) {
            return Tokens.newKeywordToken(tokenString);
        }
        return Tokens.newLiteralToken(tokenString);
    }

    private Token scanNumber(CharacterStream characterStream) throws SyntaxException {
        char currentChar;
        StringBuilder value = new StringBuilder();
        value.append(characterStream.current());
        while (characterStream.hasNext() && !CharacterHelper.isWhiteSpace(currentChar = characterStream.next())) {
            if (!CharacterHelper.isNum(currentChar)) {
                throw new SyntaxException(String.format("Bad character '%s' in number starting with '%s'!", Character.valueOf(currentChar), value.toString()));
            }
            value.append(currentChar);
        }
        return Tokens.newIntegerToken(Integer.valueOf(value.toString()));
    }

    private Token scanString(CharacterStream characterStream) throws SyntaxException {
        StringBuilder value = new StringBuilder();
        char startQuote = characterStream.current();
        boolean terminated = false;
        while (characterStream.hasNext()) {
            char currentChar = characterStream.next();
            if (currentChar == startQuote) {
                terminated = true;
                if (!characterStream.hasNext()) break;
                characterStream.next();
                break;
            }
            value.append(currentChar);
        }
        if (!terminated) {
            throw new SyntaxException(String.format("Unterminated string '%s'!", value.toString()));
        }
        return Tokens.newStringToken(value.toString());
    }

    private boolean isKeyword(String token) {
        return this.commandMap.isCommand(token) || this.commandMap.isSubCommand(token);
    }
}

