/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.guava;

import de.weltraumschaf.commons.guava.Collections2;
import de.weltraumschaf.commons.guava.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class Lists {
    private Lists() {
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        return elements instanceof Collection ? new ArrayList<E>(Collections2.cast(elements)) : Lists.newArrayList(elements.iterator());
    }

    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList<E> list = Lists.newArrayList();
        Iterators.addAll(list, elements);
        return list;
    }
}

