/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.concurrent;

import de.weltraumschaf.commons.concurrent.Stack;
import java.util.concurrent.atomic.AtomicReference;

class ConcurrentStack<E>
implements Stack<E> {
    private final AtomicReference<Entry<E>> top = new AtomicReference();

    ConcurrentStack() {
    }

    @Override
    public boolean isEmpty() {
        return null == this.top.get();
    }

    @Override
    public E peek() {
        Entry<E> currentTop = this.top.get();
        return (E)(null == currentTop ? null : ((Entry)currentTop).element);
    }

    @Override
    public E pop() {
        Entry<E> currentTop;
        do {
            if (null != (currentTop = this.top.get())) continue;
            return null;
        } while (!this.top.compareAndSet(currentTop, ((Entry)currentTop).next));
        return (E)((Entry)currentTop).element;
    }

    @Override
    public void push(E element) {
        Entry<E> currentTop;
        while (!this.top.compareAndSet(currentTop = this.top.get(), new Entry<E>(element, currentTop))) {
        }
    }

    private static class Entry<T> {
        private final T element;
        private final Entry<T> next;

        Entry(T element, Entry<T> next) {
            this.element = element;
            this.next = next;
        }
    }
}

