/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.concurrent;

import de.weltraumschaf.commons.concurrent.Queue;
import java.util.concurrent.atomic.AtomicReference;

class ConcurrentQueue<E>
implements Queue<E> {
    private final AtomicReference<Entry<E>> head = new AtomicReference();
    private final AtomicReference<Entry<E>> tail = new AtomicReference();

    ConcurrentQueue() {
    }

    @Override
    public boolean isEmpty() {
        return null == this.head.get() && null == this.tail.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(E element) {
        Entry<E> node = new Entry<E>(element);
        while (true) {
            if (null == this.head.get()) {
                if (!this.head.compareAndSet(null, node)) continue;
                return;
            }
            Entry<E> currentTail = this.tail.get();
            if (null == currentTail) {
                Entry<E> currentHead = this.head.get();
                ((Entry)currentHead).next = (Entry)node;
                if (!this.tail.compareAndSet(currentTail, node) || !this.head.compareAndSet(currentHead, currentHead)) continue;
                return;
            }
            ((Entry)currentTail).next = (Entry)node;
            if (this.tail.compareAndSet(currentTail, node)) return;
        }
    }

    @Override
    public E get() {
        Entry<E> currentHead;
        do {
            if (null != (currentHead = this.head.get())) continue;
            return null;
        } while (!(null == ((Entry)currentHead).next ? this.head.compareAndSet(currentHead, ((Entry)currentHead).next) && this.tail.compareAndSet(this.tail.get(), null) : this.head.compareAndSet(currentHead, ((Entry)currentHead).next)));
        return (E)((Entry)currentHead).element;
    }

    private static class Entry<T> {
        private final T element;
        private Entry<T> next;

        Entry(T element) {
            this.element = element;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.element != null ? this.element.hashCode() : 0);
            hash = 47 * hash + (this.next != null ? this.next.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            if (!(this.element == other.element || this.element != null && this.element.equals(other.element))) {
                return false;
            }
            return this.next == other.next || this.next != null && this.next.equals(other.next);
        }

        public String toString() {
            String nextHashcode = null == this.next ? "null" : Integer.toHexString(this.next.hashCode());
            return String.format("%s (%s -> %s)", this.element, Integer.toHexString(this.hashCode()), nextHashcode);
        }
    }
}

