/*
 * LICENSE
 *
 * "THE BEER-WARE LICENSE" (Revision 43):
 * "Sven Strittmatter" <weltraumschaf(at)googlemail(dot)com> wrote this file.
 * As long as you retain this notice you can do whatever you want with
 * this stuff. If we meet some day, and you think this stuff is worth it,
 * you can buy me a non alcohol-free beer in return.
 *
 * Copyright (C) 2012 "Sven Strittmatter" <weltraumschaf(at)googlemail(dot)com>
 */
package de.weltraumschaf.commons.shell;

/**
 * Parses input line from interactive shell.
 *
 * @author Sven Strittmatter <weltraumschaf@googlemail.com>
 */
public interface Parser {

    /**
     * Parses given input line.
     *
     * @param input line to parse
     * @return recognized shell command
     * @throws SyntaxException if, the parsed line has syntax errors
     */
    ShellCommand parse(final String input) throws SyntaxException;

}
