/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.system;

public enum OperatingSystem {
    WINDOWS("win"),
    LINUX("linux"),
    MACOSX("mac os x"),
    UNKNOWN;

    private final String name;

    private OperatingSystem() {
        this("");
    }

    private OperatingSystem(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static OperatingSystem determine(String osNameProperty) {
        String normalizedOsNameProperty = osNameProperty.toLowerCase();
        if (normalizedOsNameProperty.indexOf("linux") >= 0) {
            return LINUX;
        }
        if (normalizedOsNameProperty.indexOf("mac os x") >= 0) {
            return MACOSX;
        }
        if (normalizedOsNameProperty.indexOf("win") >= 0) {
            return WINDOWS;
        }
        return UNKNOWN;
    }
}

