/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

import com.google.common.base.Objects;
import de.weltraumschaf.commons.shell.TokenType;

public final class Token<T> {
    private final TokenType type;
    private final T value;

    private Token(TokenType type, T value) {
        this.type = type;
        this.value = value;
    }

    public static Token<String> newKeywordToken(String value) {
        return new Token<String>(TokenType.KEYWORD, value);
    }

    public static Token<String> newStringToken(String value) {
        return new Token<String>(TokenType.STRING, value);
    }

    public static Token<String> newLiteralToken(String value) {
        return new Token<String>(TokenType.LITERAL, value);
    }

    public static Token<Integer> newNumberToken(Integer value) {
        return new Token<Integer>(TokenType.NUMBER, value);
    }

    public TokenType getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("value", this.value).toString();
    }
}

