/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

import com.google.common.collect.Maps;
import de.weltraumschaf.commons.shell.MainCommandType;
import de.weltraumschaf.commons.shell.SubCommandType;
import de.weltraumschaf.commons.shell.Token;
import java.util.Map;

public abstract class LiteralCommandMap {
    private final Map<String, MainCommandType> commands = Maps.newHashMap();
    private final Map<String, SubCommandType> subCommands = Maps.newHashMap();
    private final SubCommandType defaultSubCommand;

    public LiteralCommandMap(SubCommandType defaultSubCommand) {
        this.defaultSubCommand = defaultSubCommand;
        this.initCommandMap(this.commands);
        this.initSubCommandMap(this.subCommands);
    }

    public final boolean isCommand(Token<String> token) {
        return this.isCommand(token.getValue());
    }

    public final boolean isCommand(String token) {
        return this.commands.containsKey(token);
    }

    public final MainCommandType determineCommand(Token<String> t) {
        if (!this.isCommand(t)) {
            throw new IllegalArgumentException(String.format("'%s' is not a command!", t.getValue()));
        }
        return this.commands.get(t.getValue());
    }

    public final boolean isSubCommand(Token<String> token) {
        return this.isSubCommand(token.getValue());
    }

    public final boolean isSubCommand(String token) {
        return this.subCommands.containsKey(token);
    }

    public final SubCommandType determineSubCommand(Token<String> t) {
        if (!this.isSubCommand(t)) {
            throw new IllegalArgumentException(String.format("'%s' is not a sub command!", t.getValue()));
        }
        return this.subCommands.get(t.getValue());
    }

    public SubCommandType getDefaultSubCommand() {
        return this.defaultSubCommand;
    }

    protected abstract void initCommandMap(Map<String, MainCommandType> var1);

    protected abstract void initSubCommandMap(Map<String, SubCommandType> var1);
}

