/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

import com.google.common.collect.Lists;
import de.weltraumschaf.commons.shell.CommandVerifier;
import de.weltraumschaf.commons.shell.LiteralCommandMap;
import de.weltraumschaf.commons.shell.MainCommandType;
import de.weltraumschaf.commons.shell.Parser;
import de.weltraumschaf.commons.shell.Scanner;
import de.weltraumschaf.commons.shell.ShellCommand;
import de.weltraumschaf.commons.shell.SubCommandType;
import de.weltraumschaf.commons.shell.SyntaxException;
import de.weltraumschaf.commons.shell.Token;
import de.weltraumschaf.commons.shell.TokenType;
import java.util.List;

class DefaultParser
implements Parser {
    private final Scanner scanner;
    private final CommandVerifier verifier;
    private final LiteralCommandMap commandMap;

    public DefaultParser(Scanner scanner, CommandVerifier verifier, LiteralCommandMap commandMap) {
        this.scanner = scanner;
        this.verifier = verifier;
        this.commandMap = commandMap;
    }

    @Override
    public ShellCommand parse(String input) throws SyntaxException {
        Token secondToken;
        List<Token> tokens = this.scanner.scan(input);
        Token commandtoken = tokens.get(0);
        if (TokenType.KEYWORD != commandtoken.getType()) {
            throw new SyntaxException("Command expected as first input!");
        }
        MainCommandType command = this.commandMap.determineCommand(commandtoken);
        SubCommandType subCommand = this.commandMap.getDefaultSubCommand();
        int argumentBegin = 1;
        if (tokens.size() > 1 && (secondToken = tokens.get(1)).getType() == TokenType.KEYWORD) {
            if (!this.commandMap.isSubCommand(secondToken)) {
                throw new SyntaxException(String.format("Command '%s' followed by bad keyword '%s' as sub command!", commandtoken.getValue(), secondToken.getValue()));
            }
            ++argumentBegin;
            subCommand = this.commandMap.determineSubCommand(secondToken);
        }
        List<Object> arguments = tokens.size() > argumentBegin ? tokens.subList(argumentBegin, tokens.size()) : Lists.newArrayList();
        ShellCommand cmd = new ShellCommand(command, subCommand, arguments);
        this.verifier.verifyCommand(cmd);
        return cmd;
    }
}

