/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.shell;

public final class CharacterHelper {
    private CharacterHelper() {
    }

    public static boolean isCharInRange(char character, char start, char end) {
        if (end < start) {
            throw new IllegalArgumentException("End must be greater or equal than start!");
        }
        return start <= character && character <= end;
    }

    public static boolean isAlpha(char character) {
        return CharacterHelper.isCharInRange(character, 'a', 'z') || CharacterHelper.isCharInRange(character, 'A', 'Z');
    }

    public static boolean isNum(char character) {
        return CharacterHelper.isCharInRange(character, '0', '9');
    }

    public static boolean isAlphaNum(char character) {
        return CharacterHelper.isAlpha(character) || CharacterHelper.isNum(character);
    }

    public static boolean isWhiteSpace(char character) {
        return ' ' == character || '\t' == character || '\n' == character || '\r' == character;
    }

    public static boolean isQuote(char character) {
        return '\'' == character || '\"' == character;
    }
}

