/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.system;

import de.weltraumschaf.commons.system.OperatingSystem;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public final class BrowserLauncher {
    private final OperatingSystem os;
    private final Runtime runtime;

    public BrowserLauncher() {
        this(OperatingSystem.determine(System.getProperty("os.name", "")), Runtime.getRuntime());
    }

    public BrowserLauncher(OperatingSystem os, Runtime runtime) {
        this.os = os;
        this.runtime = runtime;
    }

    private boolean openLinuxBrowser(String url) {
        boolean started = false;
        boolean isDefaultKonqueror = false;
        try {
            File file;
            String canonical;
            Process process = this.runtime.exec("which x-www-browser");
            BufferedInputStream ins = new BufferedInputStream(process.getInputStream());
            BufferedReader bufreader = new BufferedReader(new InputStreamReader(ins));
            String defaultLinkPath = bufreader.readLine();
            ins.close();
            if (defaultLinkPath != null && (canonical = (file = new File(defaultLinkPath)).getCanonicalPath()).indexOf("konqueror") != -1) {
                isDefaultKonqueror = true;
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (!started && !isDefaultKonqueror) {
            try {
                this.runtime.exec("x-www-browser " + url);
                started = true;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!started) {
            try {
                this.runtime.exec("firefox " + url);
                started = true;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!started) {
            try {
                this.runtime.exec("mozilla " + url);
                started = true;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!started) {
            try {
                this.runtime.exec("konqueror " + url);
                started = true;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return started;
    }

    private boolean openMacBrowser(String url) {
        boolean started = false;
        if (!started) {
            try {
                this.runtime.exec("open " + url);
                started = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return started;
    }

    private boolean openWindowsBrowser(String url) {
        boolean started = false;
        if (!started) {
            try {
                this.runtime.exec("cmd /c start " + url);
                started = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return started;
    }

    public void openBrowser(String url) {
        boolean started = false;
        switch (this.os) {
            case LINUX: {
                started = this.openLinuxBrowser(url);
                break;
            }
            case MACOSX: {
                started = this.openMacBrowser(url);
                break;
            }
            case WINDOWS: {
                started = this.openWindowsBrowser(url);
            }
        }
        if (!started) {
            throw new RuntimeException("Failed to open browser. Please go to " + url);
        }
    }
}

