/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons;

import de.weltraumschaf.commons.IO;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public final class IOStreams
implements IO {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public IOStreams(InputStream stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    @Override
    public PrintStream getStderr() {
        return this.stderr;
    }

    @Override
    public InputStream getStdin() {
        return this.stdin;
    }

    @Override
    public PrintStream getStdout() {
        return this.stdout;
    }

    public static IOStreams newDefault() throws UnsupportedEncodingException {
        return IOStreams.newDefault(DEFAULT_ENCODING);
    }

    public static IOStreams newDefault(String encoding) throws UnsupportedEncodingException {
        PrintStream out = new PrintStream((OutputStream)System.out, true, encoding);
        PrintStream err = new PrintStream((OutputStream)System.err, true, encoding);
        System.setOut(out);
        System.setErr(err);
        return new IOStreams(System.in, out, err);
    }

    @Override
    public void printStackTrace(Throwable ex) {
        ex.printStackTrace(this.getStderr());
    }

    @Override
    public void errorln(String str) {
        this.getStderr().println(str);
    }

    @Override
    public void error(String str) {
        this.getStderr().print(str);
    }

    @Override
    public void println(String str) {
        this.getStdout().println(str);
    }

    @Override
    public void print(String str) {
        this.getStdout().print(str);
    }
}

