/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons;

import de.weltraumschaf.commons.IOStreams;
import de.weltraumschaf.commons.Invokable;
import de.weltraumschaf.commons.ShutDownHook;
import de.weltraumschaf.commons.system.DefaultExiter;
import de.weltraumschaf.commons.system.ExitCode;
import de.weltraumschaf.commons.system.Exitable;

public abstract class InvokableAdapter
implements Invokable {
    private final String[] args;
    private final ShutDownHook shutDownHook;
    private IOStreams ioStreams;
    private Exitable exiter = new DefaultExiter();
    private final Runtime runtime;

    public InvokableAdapter(String[] args) {
        this(args, Runtime.getRuntime(), new ShutDownHook());
    }

    public InvokableAdapter(String[] args, Runtime runtime, ShutDownHook shutDownHook) {
        this.args = (String[])args.clone();
        this.runtime = runtime;
        this.shutDownHook = shutDownHook;
    }

    public static void main(Invokable invokanle) {
        InvokableAdapter.main(invokanle, IOStreams.newDefault());
    }

    public static void main(Invokable invokanle, IOStreams ioStreams) {
        invokanle.setIoStreams(ioStreams);
        try {
            invokanle.init();
            invokanle.execute();
        }
        catch (Exception ex) {
            ioStreams.errorln(ex.getMessage());
            invokanle.exit(-1);
        }
        invokanle.exit(0);
    }

    @Override
    public final void init() {
        this.runtime.addShutdownHook(this.shutDownHook);
    }

    public final String[] getArgs() {
        return (String[])this.args.clone();
    }

    @Override
    public final IOStreams getIoStreams() {
        return this.ioStreams;
    }

    @Override
    public final void setIoStreams(IOStreams ioStreams) {
        this.ioStreams = ioStreams;
    }

    public final void registerShutdownHook(Runnable callback) {
        this.shutDownHook.register(callback);
    }

    @Override
    public final void exit(int status) {
        this.exiter.exit(status);
    }

    @Override
    public final void exit(ExitCode status) {
        this.exiter.exit(status);
    }

    @Override
    public final void setExiter(Exitable exiter) {
        this.exiter = exiter;
    }
}

