/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons;

import java.io.InputStream;
import java.io.PrintStream;

public final class IOStreams {
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public IOStreams(InputStream stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public static IOStreams newDefault() {
        return new IOStreams(System.in, System.out, System.err);
    }

    public void printStackTrace(Exception ex) {
        ex.printStackTrace(this.getStderr());
    }

    public void errorln(String str) {
        this.getStderr().println(str);
    }

    public void error(String str) {
        this.getStderr().print(str);
    }

    public void println(String str) {
        this.getStdout().println(str);
    }

    public void print(String str) {
        this.getStdout().print(str);
    }
}

