/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons.swing;

import de.weltraumschaf.commons.system.DefaultExiter;
import de.weltraumschaf.commons.system.Exitable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SwingFrame
extends JFrame {
    static final String MAC_OSX = "Mac OS X";
    private static final Logger LOGGER = Logger.getLogger(SwingFrame.class.getName());
    protected final JPanel panel = new JPanel();
    protected boolean exitOnCloseWindow;
    private transient Exitable exiter = new DefaultExiter();

    public SwingFrame(String title) throws HeadlessException {
        super(title);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panel, "Center");
    }

    public final void init() {
        this.initLookAndFeel();
        if (this.exitOnCloseWindow) {
            this.bindWindowClosing();
        }
        this.initMenu();
        this.initToolBar();
        this.pack();
    }

    public void setExitOnCloseWindow(boolean exitOnCloseWindow) {
        this.exitOnCloseWindow = exitOnCloseWindow;
    }

    public void setExiter(Exitable exiter) {
        this.exiter = exiter;
    }

    public static boolean isMacOs() {
        return System.getProperty("os.name").equals(MAC_OSX);
    }

    protected void initLookAndFeel() {
        if (SwingFrame.isMacOs()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    protected void bindWindowClosing() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingFrame.this.exiter.exit(0);
            }
        });
    }

    protected void initMenu() {
    }

    protected void initToolBar() {
    }
}

