/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Version {
    private final String propertyFileName;
    private boolean propertiesLoaded;
    private final Properties properties = new Properties();

    public Version(String propertyFileName) {
        this.propertyFileName = propertyFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (!this.propertiesLoaded) {
            InputStream in = null;
            try {
                in = this.getClass().getResourceAsStream(this.propertyFileName);
                this.properties.load(in);
                in.close();
                this.propertiesLoaded = true;
            }
            finally {
                if (null != in) {
                    in.close();
                }
            }
        }
    }

    public String getVersion() {
        return this.properties.getProperty(PropertyNames.VERSION.toString(), PropertyNames.VERSION.getDefaultValue());
    }

    public String toString() {
        return this.getVersion();
    }

    static enum PropertyNames {
        VERSION("version", "n/a");

        private final String name;
        private final String defaultValue;

        private PropertyNames(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

