/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons;

import de.weltraumschaf.commons.IOStreams;
import de.weltraumschaf.commons.Invokable;
import de.weltraumschaf.commons.ShutDownHook;
import de.weltraumschaf.commons.system.DefaultExiter;
import de.weltraumschaf.commons.system.ExitCode;
import de.weltraumschaf.commons.system.Exitable;

public abstract class InvokableAdapter
implements Invokable {
    private final String[] args;
    private final ShutDownHook shutDownHooks = new ShutDownHook();
    private IOStreams ioStreams;
    private Exitable exiter = new DefaultExiter();

    public InvokableAdapter(String[] args) {
        this.args = (String[])args.clone();
    }

    public static void main(Invokable invokanle) {
        InvokableAdapter.main(invokanle, IOStreams.newDefault());
    }

    public static void main(Invokable invokanle, IOStreams ioStreams) {
        invokanle.setIoStreams(ioStreams);
        try {
            invokanle.init();
            invokanle.execute();
        }
        catch (Exception ex) {
            ioStreams.println(ex.getMessage());
            invokanle.exit(-1);
        }
        invokanle.exit(0);
    }

    @Override
    public final void init() throws Exception {
        Runtime.getRuntime().addShutdownHook(this.shutDownHooks);
    }

    public String[] getArgs() {
        return (String[])this.args.clone();
    }

    @Override
    public IOStreams getIoStreams() {
        return this.ioStreams;
    }

    @Override
    public void setIoStreams(IOStreams ioStreams) {
        this.ioStreams = ioStreams;
    }

    protected ShutDownHook getShutDownHooks() {
        return this.shutDownHooks;
    }

    @Override
    public void exit(int status) {
        this.exiter.exit(status);
    }

    @Override
    public void exit(ExitCode status) {
        this.exiter.exit(status);
    }

    @Override
    public void setExiter(Exitable exiter) {
        this.exiter = exiter;
    }
}

