/*
 * Decompiled with CFR 0.152.
 */
package de.weltraumschaf.commons;

import de.weltraumschaf.commons.IOStreams;
import de.weltraumschaf.commons.Invokable;
import de.weltraumschaf.commons.ShutDownHook;

public abstract class InvokableAdapter
implements Invokable {
    private final String[] args;
    private IOStreams ioStreams;
    private final ShutDownHook shutDownHooks = new ShutDownHook();

    public InvokableAdapter(String[] args) {
        this.args = (String[])args.clone();
    }

    public static void main(Invokable invokanle) {
        InvokableAdapter.main(invokanle, IOStreams.newDefault());
    }

    public static void main(Invokable invokanle, IOStreams ioStreams) {
        invokanle.setIoStreams(ioStreams);
        try {
            invokanle.init();
            invokanle.execute();
        }
        catch (Exception ex) {
            ioStreams.println(ex.getMessage());
            invokanle.exit(-1);
        }
        invokanle.exit(0);
    }

    @Override
    public final void init() throws Exception {
        Runtime.getRuntime().addShutdownHook(this.shutDownHooks);
    }

    public String[] getArgs() {
        return (String[])this.args.clone();
    }

    @Override
    public IOStreams getIoStreams() {
        return this.ioStreams;
    }

    @Override
    public void setIoStreams(IOStreams ioStreams) {
        this.ioStreams = ioStreams;
    }

    protected ShutDownHook getShutDownHooks() {
        return this.shutDownHooks;
    }

    @Override
    public void exit(int status) {
        System.exit(status);
    }
}

