/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResolver
implements URIResolver {
    private static Logger LOG = LoggerFactory.getLogger(ResourceResolver.class);

    public static InputStream openFile(String string) {
        return ResourceResolver.openFile(string, Thread.currentThread().getContextClassLoader());
    }

    public static InputStream openFile(String string, ClassLoader classLoader) {
        Object object;
        InputStream inputStream = null;
        Object object2 = "";
        object2 = string.length() > 20 ? string.substring(0, 20) + "..." : string;
        LOG.trace("Resolving resource {}", object2);
        try {
            inputStream = new BufferedInputStream(new FileInputStream(string));
        }
        catch (Exception exception) {
            LOG.trace(exception.getMessage());
        }
        if (inputStream == null) {
            try {
                LOG.trace("Resolving resource {} as URL", object2);
                object = new URL(string);
                inputStream = ((URL)object).openStream();
            }
            catch (Exception exception) {
                LOG.trace(exception.getMessage());
            }
        }
        if (inputStream == null) {
            try {
                LOG.trace("Resolving resource {} as File", object2);
                object = ResourceResolver.class.getResource(string).getPath();
                LOG.trace("Resolved path is {}", object);
                inputStream = new FileInputStream((String)object);
            }
            catch (Exception exception) {
                LOG.trace(exception.getMessage());
            }
        }
        if (inputStream == null) {
            try {
                LOG.trace("Resolving resource {} from Classpath", object2);
                inputStream = classLoader.getResourceAsStream(string);
            }
            catch (Exception exception) {
                LOG.trace(exception.getMessage());
            }
        }
        if (inputStream == null) {
            try {
                inputStream = classLoader.getResourceAsStream("/" + string);
            }
            catch (Exception exception) {
                LOG.trace(exception.getMessage());
            }
        }
        if (inputStream == null) {
            LOG.trace("Resolving resource {} as ByteStream", object2);
            inputStream = new ByteArrayInputStream(string.getBytes());
        }
        return inputStream;
    }

    @Override
    public Source resolve(String string, String string2) throws TransformerException {
        return new StreamSource(ResourceResolver.openFile(string));
    }
}

