/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import blended.util.ResourceResolver;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XMLSupport {
    private final String location;
    private final ClassLoader loader;
    private Document document = null;
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public XMLSupport(String location) {
        this(location, XMLSupport.class.getClassLoader());
    }

    public XMLSupport(String location, ClassLoader loader) {
        this.loader = loader;
        this.location = location;
    }

    public Document getDocument() throws Exception {
        if (this.document == null) {
            DocumentBuilder builder = DOC_BUILDER_FACTORY.newDocumentBuilder();
            InputStream is = ResourceResolver.openFile(this.location, this.loader);
            if (is == null) {
                throw new Exception("Location [" + this.location + "] couldn't be resolved.");
            }
            this.document = builder.parse(new InputSource(is));
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.document;
    }

    public String applyXPath(String query) throws Exception {
        final Element element = this.getDocument().getDocumentElement();
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            if (element.getNamespaceURI() != null) {
                xpath.setNamespaceContext(new NamespaceContext(){

                    @Override
                    public String getNamespaceURI(String prefix) {
                        return element.getNamespaceURI();
                    }

                    @Override
                    public String getPrefix(String namespaceURI) {
                        throw new UnsupportedOperationException();
                    }

                    public Iterator getPrefixes(String namespaceURI) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            XPathExpression expr = xpath.compile(query);
            return expr.evaluate(element);
        }
        catch (Exception e) {
            String msg = "Error evaluating XPath [" + query + "] on element [" + element.getTagName() + "].";
            throw new Exception(msg, e);
        }
    }

    public void validate(String schemaLocation) throws Exception {
        StreamSource schemaFile = new StreamSource(ResourceResolver.openFile(schemaLocation));
        StreamSource content = new StreamSource(ResourceResolver.openFile(this.location));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        validator.validate(content);
    }

    static {
        DOC_BUILDER_FACTORY.setXIncludeAware(true);
        DOC_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

