/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResolver
implements URIResolver {
    private static Logger LOG = LoggerFactory.getLogger(ResourceResolver.class);

    public static InputStream openFile(String location) {
        return ResourceResolver.openFile(location, Thread.currentThread().getContextClassLoader());
    }

    public static InputStream openFile(String location, ClassLoader loader) {
        InputStream is = null;
        String loc = "";
        loc = location.length() > 20 ? location.substring(0, 20) + "..." : location;
        LOG.debug("Resolving resource {}", (Object)loc);
        try {
            is = new BufferedInputStream(new FileInputStream(location));
        }
        catch (Exception e) {
            LOG.debug(e.getMessage());
        }
        if (is == null) {
            try {
                LOG.debug("Resolving resource {} as URL", (Object)loc);
                URL url = new URL(location);
                is = url.openStream();
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (is == null) {
            try {
                LOG.debug("Resolving resource {} as File", (Object)loc);
                String path = ResourceResolver.class.getResource(location).getPath();
                LOG.debug("Resolved path is {}", (Object)path);
                is = new FileInputStream(path);
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (is == null) {
            try {
                LOG.debug("Resolving resource {} from Classpath", (Object)loc);
                is = loader.getResourceAsStream(location);
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (is == null) {
            try {
                is = loader.getResourceAsStream("/" + location);
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        }
        if (is == null) {
            LOG.debug("Resolving resource {} as ByteStream", (Object)loc);
            is = new ByteArrayInputStream(location.getBytes());
        }
        return is;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        return new StreamSource(ResourceResolver.openFile(href));
    }
}

