/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import blended.util.ResourceResolver;
import blended.util.StreamCopySupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileHelper {
    public static void writeFile(File f, byte[] content) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        FileOutputStream os = new FileOutputStream(f);
        StreamCopySupport.copyStream(is, os);
        FileHelper.safeClose(is);
        FileHelper.safeClose(os);
    }

    public static byte[] readStream(InputStream is) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamCopySupport.copyStream(is, bos);
        FileHelper.safeClose(is);
        FileHelper.safeClose(bos);
        return bos.toByteArray();
    }

    public static byte[] readFile(String location) throws Exception {
        InputStream is = ResourceResolver.openFile(location);
        return FileHelper.readStream(is);
    }

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void safeClose(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

