/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionHelper.class);

    private ReflectionHelper() {
    }

    public static List<String> getPropertyNames(Object obj) {
        List<Method> getter = ReflectionHelper.getGetterMethods(obj.getClass());
        ArrayList<String> result = new ArrayList<String>();
        for (Method m : getter) {
            LOGGER.info(m.getName());
            result.add(ReflectionHelper.getPropertyName(m));
        }
        return result;
    }

    public static <T> T getProperty(Object object, String ... propertyNames) {
        String part;
        if (propertyNames == null || object == null) {
            return null;
        }
        Object current = object;
        String[] arr$ = propertyNames;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (current = ReflectionHelper.getPropertyInternal(current, part = arr$[i$])) != null; ++i$) {
        }
        try {
            Object result = current;
            return (T)result;
        }
        catch (ClassCastException cce) {
            ReflectionHelper.getLogger().warn("ReflectionHelper encountered wrong property type: " + current.getClass().getName());
            return null;
        }
    }

    public static <T> T getProperty(Object object, String propertyName) {
        if (propertyName == null) {
            return null;
        }
        return ReflectionHelper.getProperty(object, propertyName.split("\\."));
    }

    public static void setProperty(Object object, Object value, String ... propertyNames) {
        try {
            if (object == null || propertyNames == null || propertyNames.length == 0) {
                throw new Exception("Destination object and property name must not be empty to set the property");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Wrong context to set property", (Throwable)e);
            return;
        }
        Object current = object;
        for (int i = 0; i < propertyNames.length - 1; ++i) {
            if ((current = ReflectionHelper.getPropertyInternal(current, propertyNames[i])) != null) continue;
            LOGGER.warn("Property [" + propertyNames[i] + "] not found for object [" + current + "]");
            break;
        }
        if (current != null) {
            ReflectionHelper.setPropertyInternal(current, propertyNames[propertyNames.length - 1], value);
        }
    }

    private static void setPropertyInternal(Object object, String propertyName, Object value) {
        for (Method m : ReflectionHelper.getSetterMethods(object.getClass())) {
            if (!ReflectionHelper.getPropertyName(m).equals(propertyName)) continue;
            try {
                LOGGER.debug("Setting property [{}] to [{}]", (Object)propertyName, value);
                m.invoke(object, value);
            }
            catch (Exception e) {
                Class<?> pType = m.getParameterTypes()[0];
                Class tClass = Object.class;
                tClass = pType.isPrimitive() && pType.getName().equals("boolean") ? Boolean.class : (pType.isPrimitive() && pType.getName().equals("long") ? Long.class : (pType.isPrimitive() && pType.getName().equals("short") ? Short.class : (pType.isPrimitive() && pType.getName().equals("int") ? Integer.class : (pType.isPrimitive() && pType.getName().equals("float") ? Float.class : (pType.isPrimitive() && pType.getName().equals("double") ? Double.class : (pType.isPrimitive() && pType.getName().equals("byte") ? Byte.class : pType))))));
                try {
                    Constructor constructor = tClass.getConstructor(value.getClass());
                    m.invoke(object, constructor.newInstance(value));
                }
                catch (NoSuchMethodException nsme) {
                    LOGGER.warn("No constructor found for [{}] from type [{}]", (Object)tClass.getName(), value.getClass());
                    return;
                }
                catch (Exception e1) {
                    LOGGER.warn("Failed to set property ... trying to convert [{}] into [{}]", (Object)value.getClass().getName(), (Object)m.getParameterTypes()[0].getName());
                }
            }
        }
    }

    public static List<Method> getGetterMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!m.getName().startsWith("get") || m.getName().equals("getClass") || m.getParameterTypes().length != 0) continue;
            result.add(m);
        }
        return result;
    }

    public static List<Method> getSetterMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            result.add(m);
        }
        return result;
    }

    public static String getPropertyName(Class<?> clazz, Class<?> propertyType) {
        for (Method getter : ReflectionHelper.getGetterMethods(clazz)) {
            if (!getter.getReturnType().equals(propertyType)) continue;
            try {
                clazz.getMethod(getter.getName().replaceFirst("g", "s"), propertyType);
                return ReflectionHelper.getPropertyName(getter);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static String getPropertyName(Method m) {
        String result = null;
        if (m.getName().startsWith("get") || m.getName().startsWith("set")) {
            result = m.getName().substring(3);
            if (result.length() == 1) {
                result = result.toLowerCase();
            } else if (result.matches(".[a-z](.)*")) {
                result = result.substring(0, 1).toLowerCase() + result.substring(1);
            }
        }
        return result;
    }

    private static Object getPropertyInternal(Object object, String propertyName) {
        for (Method m : ReflectionHelper.getGetterMethods(object.getClass())) {
            if (!ReflectionHelper.getPropertyName(m).equals(propertyName)) continue;
            try {
                Object result = m.invoke(object, new Object[0]);
                return result;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ReflectionHelper.class);
    }
}

