/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import blended.util.ResourceResolver;
import blended.util.StreamCopySupport;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileReader {
    public static byte[] readStream(InputStream is) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamCopySupport.copyStream(is, bos);
        FileReader.safeClose(is);
        FileReader.safeClose(bos);
        return bos.toByteArray();
    }

    public static byte[] readFile(String location) throws Exception {
        InputStream is = ResourceResolver.openFile(location);
        return FileReader.readStream(is);
    }

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void safeClose(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

